<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */

    include "../../include/includeBaseControllerComponenti.php";
    include "../../../../gUtil/ControlloreStringhe.php";
    include "../../../../classi/GeneratoreUrl.php";
    include "../../../../classi/Contenuto.php";
    include "../classi/Portfolio.php";
    include "../classi/ElementoPortfolio.php";
    
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $portfolio = new Portfolio($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $portfolio = new Portfolio($geecomDb, filter_input(INPUT_GET, "id"));
    }
    
    switch ($operazione) {
        case 'crea':
            $filtrabile = (isset($_POST["filtrabile"]) && $_POST["filtrabile"]=="si") ? "si" : "no";
            $portfolio->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $portfolio->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $portfolio->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
            $portfolio->setEtichettaAltriElementi(filter_input(INPUT_POST,"etichettaAltriElementi",FILTER_SANITIZE_ADD_SLASHES));
            $portfolio->setLinkPagina(filter_input(INPUT_POST,"linkPagina",FILTER_SANITIZE_STRING));
            $portfolio->setClasseElementi(filter_input(INPUT_POST,"classeElementi",FILTER_SANITIZE_STRING));
            $portfolio->setAspectRatio(filter_input(INPUT_POST,"aspectRatio",FILTER_SANITIZE_STRING));
            $portfolio->setFiltrabile($filtrabile);
            $portfolio->setSenzaBordi(filter_input(INPUT_POST,"senzaBordi",FILTER_SANITIZE_STRING));
            $portfolio->setAspetto(filter_input(INPUT_POST,"aspetto",FILTER_SANITIZE_STRING));
            $portfolio->setMostraNomiElementi(filter_input(INPUT_POST,"mostraNomiElementi",FILTER_SANITIZE_STRING));
            $portfolio->setMostraImmagineInEvidenza(filter_input(INPUT_POST,"mostraImmagineInEvidenza",FILTER_SANITIZE_STRING));
            $portfolio->setTraduzioneItaliano(filter_input(INPUT_POST,"traduzioneItaliano",FILTER_SANITIZE_NUMBER_INT));
            $portfolio->setTraduzioneInglese(filter_input(INPUT_POST,"traduzioneInglese",FILTER_SANITIZE_NUMBER_INT));
            $portfolio->setTraduzioneTedesco(filter_input(INPUT_POST,"traduzioneTedesco",FILTER_SANITIZE_NUMBER_INT));
            $portfolio->setTraduzioneFrancese(filter_input(INPUT_POST,"traduzioneFrancese",FILTER_SANITIZE_NUMBER_INT));
            $portfolio->setTraduzioneSpagnolo(filter_input(INPUT_POST,"traduzioneSpagnolo",FILTER_SANITIZE_NUMBER_INT));
            $portfolio->crea();
            header("Location: ../creaPortfolio.php?id={$portfolio->getId()}&status=200");
            break;
        case 'modifica':
            $filtrabile = (isset($_POST["filtrabile"]) && $_POST["filtrabile"]=="si") ? "si" : "no";
            $portfolio->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $portfolio->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $portfolio->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
            $portfolio->setEtichettaAltriElementi(filter_input(INPUT_POST,"etichettaAltriElementi",FILTER_SANITIZE_ADD_SLASHES));
            $portfolio->setLinkPagina(filter_input(INPUT_POST,"linkPagina",FILTER_SANITIZE_STRING));
            $portfolio->setAspectRatio(filter_input(INPUT_POST,"aspectRatio",FILTER_SANITIZE_STRING));
            $portfolio->setFiltrabile($filtrabile);
            $portfolio->setClasseElementi(filter_input(INPUT_POST,"classeElementi",FILTER_SANITIZE_STRING));
            $portfolio->setMostraNomiElementi(filter_input(INPUT_POST,"mostraNomiElementi",FILTER_SANITIZE_STRING));
            $portfolio->setAspetto(filter_input(INPUT_POST,"aspetto",FILTER_SANITIZE_STRING));
            $portfolio->setSenzaBordi(filter_input(INPUT_POST,"senzaBordi",FILTER_SANITIZE_STRING));
            $portfolio->setMostraImmagineInEvidenza(filter_input(INPUT_POST,"mostraImmagineInEvidenza",FILTER_SANITIZE_STRING));
            $portfolio->setTraduzioneItaliano(filter_input(INPUT_POST,"traduzioneItaliano",FILTER_SANITIZE_NUMBER_INT));
            $portfolio->setTraduzioneInglese(filter_input(INPUT_POST,"traduzioneInglese",FILTER_SANITIZE_NUMBER_INT));
            $portfolio->setTraduzioneTedesco(filter_input(INPUT_POST,"traduzioneTedesco",FILTER_SANITIZE_NUMBER_INT));
            $portfolio->setTraduzioneFrancese(filter_input(INPUT_POST,"traduzioneFrancese",FILTER_SANITIZE_NUMBER_INT));
            $portfolio->setTraduzioneSpagnolo(filter_input(INPUT_POST,"traduzioneSpagnolo",FILTER_SANITIZE_NUMBER_INT));
            $portfolio->modifica();
            header("Location: ../creaPortfolio.php?id={$portfolio->getId()}&status=250");
            break;
        case 'elimina':
            $portfolio->elimina();
            echo "ok";
            break;
        case 'duplica':
            $portfolio->caricaDatiDalDatabase();
            $idNuovaForm = $portfolio->duplica();
            header("Location: ../creaPortfolio.php?id={$idNuovaForm}&status=260");
            break;
        case 'spostaElemento':
            $portfolio->spostaElemento(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT),filter_input(INPUT_POST, "posizione",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
        case 'duplicaElementoPortfolio':
            $elementoPortfolio = new ElementoPortfolio($geecomDb, filter_input(INPUT_GET, "idElemento",FILTER_SANITIZE_NUMBER_INT));
            $idContenutoDuplicato = $elementoPortfolio->duplica("Copia di","","elementoPortfolio");
            $portfolio->spostaElemento($idContenutoDuplicato,$elementoPortfolio->getPosizione()+1);
            header("Location: ../creaElemento.php?id=$idContenutoDuplicato&status=310");
            break;
        case 'stampaElementi':
            $portfolio->stampaElementi();
            break;
        case 'modificaElemento':
            $idElemento = filter_input(INPUT_POST,"idElemento",FILTER_SANITIZE_STRING);
            $nome       = filter_input(INPUT_POST,"nome",FILTER_SANITIZE_STRING);
            $link       = filter_input(INPUT_POST,"link",FILTER_SANITIZE_STRING);
            $testo      = filter_input(INPUT_POST,"testo",FILTER_SANITIZE_ADD_SLASHES);
            $tipo       = filter_input(INPUT_POST,"tipo",FILTER_SANITIZE_STRING);
            $slider->modificaElemento($idElemento,$nome, $link, $testo);
            header("Location: ../creaElemento.php?id={$idElemento}&status=200");
            break;
        case 'modificaImmagineElemento':
            $idElemento      = filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT);
            $tipiFileAmmessi = array("image/png","image/jpeg","image/webp","image/gif");
            $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../../../../immagini/slider", 0, $categoria->getNome());
            $esitoUpload  = $gestoreUpload->salvaFile();
            if($esitoUpload["fileElaborati"]==1) {
                if($esitoUpload["percorso"]!="") {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                }
                // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                    $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                    if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                        $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                    }
                }
            }
            else {
                $percorsoFoto = "";
            }
            $slider->cambiaImmagineElemento($idElemento,$percorsoFoto);
            
            // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
            if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                    $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                }
            }

            if($impostazioni["generaThumbnail"]=="si") {
                $percorsoFileThumbnail = str_replace("immagini/","immagini/thumbnail/",$esitoUpload["percorso"]);
                $percorsoThumbnail = str_replace("../","",$percorsoFileThumbnail);
                $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaThumbnail"], $percorsoFileThumbnail);
            }
            
            echo "../../../$percorsoFoto";
            break;
        case 'eliminaElemento':
            $portfolio->eliminaElemento(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
        case 'creaCategoriaPortfolio':
            $data  = date("Y-m-d");
            $idPortfolio = filter_input(INPUT_POST,"idPortfolio",FILTER_SANITIZE_NUMBER_INT);
            $nome  = filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES);
            $alias = str_replace(" ", "-", $nome);
            $query = "INSERT INTO `geec_categorie` (`id`, `categoriaMadre`, `categoriaRiferimento`, `tipo`, `lingua`, `nome`, `alias`, `titoloPagina`, `metaDescrizione`, `descrizione`, `foto`, `punteggioSeo`, `tipoVisualizzazione`, `numeroArticoliPerPagina`, `posizione`, `ordinamento`, `dataCreazione`) VALUES (NULL, '$idPortfolio', 0, 'categoriaPortfolio', '', '$nome', '$alias', '', '', '', '', '', '', NULL, NULL, NULL, '$data')";
            $idCategoria = $geecomDb->eseguiQueryCreazione($query);
            echo "ok";
            break;
        case 'modificaCategoriaPortfolio':
            $idCategoria = filter_input(INPUT_POST,"idCategoria",FILTER_SANITIZE_NUMBER_INT);
            $nome        = filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES);
            $query       = "UPDATE `geec_categorie` SET nome='$nome' WHERE id=$idCategoria";
            $geecomDb->eseguiQueryScrittura($query);
            echo "ok";
            break;
        case 'stampaElencoCategorie':
            $portfolio->stampaElencoCategorie();
            break;
    }